/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.core;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Feature;
import codes.biscuit.skyblockaddons.core.Language;
import codes.biscuit.skyblockaddons.utils.ColorCode;
import com.google.gson.JsonObject;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;

public enum Message {
    LANGUAGE(MessageObject.ROOT, "language"),
    SETTING_MAGMA_BOSS_WARNING(MessageObject.SETTING, "magmaBossWarning"),
    SETTING_ITEM_DROP_CONFIRMATION(MessageObject.SETTING, "itemDropConfirmation"),
    SETTING_WARNING_DURATION(MessageObject.SETTING, "warningDuration"),
    SETTING_HIDE_SKELETON_HAT_BONES(MessageObject.SETTING, "hideSkeletonHatBones"),
    SETTING_SKELETON_HAT_BONES_BAR(MessageObject.SETTING, "skeletonHatBonesBar"),
    SETTING_HIDE_FOOD_AND_ARMOR(MessageObject.SETTING, "hideFoodAndArmor"),
    SETTING_FULL_INVENTORY_WARNING(MessageObject.SETTING, "fullInventoryWarning"),
    SETTING_REPEATING(MessageObject.SETTING, "repeating"),
    SETTING_MAGMA_BOSS_TIMER(MessageObject.SETTING, "magmaBossTimer"),
    SETTING_DISABLE_EMBER_ROD_ABILITY(MessageObject.SETTING, "disableEmberRodAbility"),
    SETTING_EDIT_LOCATIONS(MessageObject.SETTING, "editLocations"),
    SETTING_GUI_SCALE(MessageObject.SETTING, "guiScale"),
    SETTING_RESET_LOCATIONS(MessageObject.SETTING, "resetLocations"),
    SETTING_SETTINGS(MessageObject.SETTING, "settings"),
    SETTING_ENCHANTS_AND_REFORGES(MessageObject.SETTING, "showReforgeOverlay"),
    SETTING_MINION_STOP_WARNING(MessageObject.SETTING, "minionStopWarning"),
    SETTING_HIDE_PLAYERS_NEAR_NPCS(MessageObject.SETTING, "hidePlayersNearNPCs"),
    SETTING_BACKPACK_STYLE(MessageObject.SETTING, "backpackStyle"),
    SETTING_SHOW_BACKPACK_PREVIEW(MessageObject.SETTING, "showBackpackPreview"),
    SETTING_HIDE_HEALTH_BAR(MessageObject.SETTING, "hideHealthBar"),
    SETTING_FULL_MINION(MessageObject.SETTING, "fullMinionWarning"),
    SETTING_USE_VANILLA_TEXTURE(MessageObject.SETTING, "useVanillaTexture"),
    SETTING_SHOW_ONLY_WHEN_HOLDING_SHIFT(MessageObject.SETTING, "showOnlyWhenHoldingShift"),
    SETTING_MANA_BAR(MessageObject.SETTING, "manaBar"),
    SETTING_HEALTH_BAR(MessageObject.SETTING, "healthBar"),
    SETTING_DEFENCE_ICON(MessageObject.SETTING, "defenseIcon"),
    SETTING_MANA_TEXT(MessageObject.SETTING, "manaNumber"),
    SETTING_HEALTH_TEXT(MessageObject.SETTING, "healthNumber"),
    SETTING_DEFENCE_TEXT(MessageObject.SETTING, "defenseNumber"),
    SETTING_DEFENCE_PERCENTAGE(MessageObject.SETTING, "defensePercentage"),
    SETTING_HEALTH_UPDATES(MessageObject.SETTING, "healthUpdates"),
    SETTING_ANCHOR_POINT(MessageObject.SETTING, "anchorPoint"),
    SETTING_HIDE_PLAYERS_IN_LOBBY(MessageObject.SETTING, "hidePlayersInLobby"),
    SETTING_TEXT_STYLE(MessageObject.SETTING, "textStyle"),
    SETTING_DARK_AUCTION_TIMER(MessageObject.SETTING, "darkAuctionTimer"),
    SETTING_ITEM_PICKUP_LOG(MessageObject.SETTING, "itemPickupLog"),
    SETTING_AVOID_PLACING_ENCHANTED_ITEMS(MessageObject.SETTING, "avoidPlacingEnchantedItems"),
    SETTING_AVOID_BREAKING_STEMS(MessageObject.SETTING, "avoidBreakingStems"),
    SETTING_STOP_BOW_CHARGE_FROM_RESETTING(MessageObject.SETTING, "stopBowChargeFromResetting"),
    SETTING_SHOW_ITEM_ANVIL_USES(MessageObject.SETTING, "showItemAnvilUses"),
    SETTING_PREVENT_MOVEMENT_ON_DEATH(MessageObject.SETTING, "preventMovementOnDeath"),
    SETTING_LOCK_SLOTS(MessageObject.SETTING, "lockSlots"),
    SETTING_LOCK_SLOT(MessageObject.SETTING, "lockSlot"),
    SETTING_DONT_RESET_CURSOR_INVENTORY(MessageObject.SETTING, "dontResetCursorInventory"),
    SETTING_SUMMONING_EYE_ALERT(MessageObject.SETTING, "summoningEyeAlert"),
    SETTING_CHANGE_COLOR(MessageObject.SETTING, "changeColor"),
    SETTING_SHOW_IN_OTHER_GAMES(MessageObject.SETTING, "showInOtherGames"),
    SETTING_DONT_OPEN_PROFILES_WITH_BOW(MessageObject.SETTING, "dontOpenProfileWithBow"),
    SETTING_MAKE_ENDERCHESTS_IN_END_GREEN(MessageObject.SETTING, "makeEnderchestsInEndGreen"),
    SETTING_STOP_DROPPING_SELLING_RARE_ITEMS(MessageObject.SETTING, "stopDroppingSellingRareItems"),
    SETTING_MAKE_BACKPACK_INVENTORIES_COLORED(MessageObject.SETTING, "makeBackpackInventoriesColored"),
    SETTING_AVOID_BREAKING_BOTTOM_SUGAR_CANE(MessageObject.SETTING, "avoidBreakingBottomSugarCane"),
    SETTING_REPLACE_ROMAN_NUMERALS_WITH_NUMBERS(MessageObject.SETTING, "replaceRomanNumeralsWithNumbers"),
    SETTING_CHANGE_BAR_COLOR_WITH_POTIONS(MessageObject.SETTING, "changeBarColorForPotions"),
    SETTING_CRAFTING_PATTERNS(MessageObject.SETTING, "craftingPatterns"),
    SETTING_FISHING_SOUND_INDICATOR(MessageObject.SETTING, "soundIndicatorForFishing"),
    SETTING_AVOID_BLINKING_NIGHT_VISION(MessageObject.SETTING, "avoidBlinkingNightVision"),
    SETTING_DISABLE_MINION_LOCATION_WARNING(MessageObject.SETTING, "disableMinionLocationWarning"),
    SETTING_JUNGLE_AXE_COOLDOWN(MessageObject.SETTING, "axeCooldownIndicator"),
    SETTING_ORGANIZE_ENCHANTMENTS(MessageObject.SETTING, "organizeLongEnchantmentLists"),
    SETTING_SHOW_ITEM_COOLDOWNS(MessageObject.SETTING, "showItemCooldowns"),
    SETTING_COLLECTION_DISPLAY(MessageObject.SETTING, "collectionDisplay"),
    SETTING_SPEED_PERCENTAGE(MessageObject.SETTING, "speedPercentage"),
    SETTING_ONLY_MINE_ORES_DEEP_CAVERNS(MessageObject.SETTING, "onlyMineOresDeepCaverns"),
    SETTING_ENABLE_MESSAGE_WHEN_ACTION_PREVENTED(MessageObject.SETTING, "enableMessageWhenActionPrevented"),
    SETTING_SLAYER_INDICATOR(MessageObject.SETTING, "revenantIndicator"),
    SETTING_SPECIAL_ZEALOT_ALERT(MessageObject.SETTING, "specialZealotAlert"),
    SETTING_ONLY_MINE_VALUABLES_NETHER(MessageObject.SETTING, "onlyMineValuablesNether"),
    SETTING_DISABLE_MAGICAL_SOUP_MESSAGE(MessageObject.SETTING, "disableMagicalSoupMessage"),
    SETTING_HIDE_PET_HEALTH_BAR(MessageObject.SETTING, "hidePetHealthBar"),
    SETTING_POWER_ORB_DISPLAY(MessageObject.SETTING, "powerOrbDisplay"),
    SETTING_POWER_ORB_DISPLAY_STYLE(MessageObject.SETTING, "powerOrbDisplayStyle"),
    SETTING_ZEALOT_COUNTER(MessageObject.SETTING, "zealotCounter"),
    SETTING_TICKER_CHARGES_DISPLAY(MessageObject.SETTING, "tickerChargesDisplay"),
    SETTING_TAB_EFFECT_TIMERS(MessageObject.SETTING, "tabEffectTimers"),
    SETTING_HIDE_NIGHT_VISION_EFFECT_TIMER(MessageObject.SETTING, "hideNightVisionEffectTimer"),
    SETTING_NO_ARROWS_LEFT_ALERT(MessageObject.SETTING, "noArrowsLeftAlert"),
    SETTING_SHOW_CAKE_BAG_PREVIEW(MessageObject.SETTING, "showCakeBagPreview"),
    SETTING_SHOW_BACKPACK_PREVIEW_AH(MessageObject.SETTING, "showBackpackPreviewInAH"),
    SETTING_ENABLE_DEV_FEATURES(MessageObject.SETTING, "enableDevFeatures"),
    SETTING_CHROMA_SPEED(MessageObject.SETTING, "chromaSpeed"),
    SETTING_CHROMA_MODE(MessageObject.SETTING, "chromaMode"),
    SETTING_CHROMA_FADE_WIDTH(MessageObject.SETTING, "chromaFadeWidth"),
    SETTING_SORT_TAB_EFFECT_TIMERS(MessageObject.SETTING, "sortTabEffectTimers"),
    SETTING_SHOW_BROKEN_FRAGMENTS(MessageObject.SETTING, "showBrokenFragments"),
    SETTING_SKYBLOCK_ADDONS_BUTTON_IN_PAUSE_MENU(MessageObject.SETTING, "skyblockAddonsButtonInPauseMenu"),
    SETTING_SHOW_TOTAL_ZEALOT_COUNT(MessageObject.SETTING, "showTotalZealotCount"),
    SETTING_SHOW_SUMMONING_EYE_COUNT(MessageObject.SETTING, "showSummoningEyeCount"),
    SETTING_SHOW_AVERAGE_ZEALOTS_PER_EYE(MessageObject.SETTING, "showZealotsPerEye"),
    SETTING_TURN_BOW_GREEN_WHEN_USING_TOXIC_ARROW_POISON(MessageObject.SETTING, "turnBowGreenWhenUsingToxicArrowPoison"),
    SETTING_BIRCH_PARK_RAINMAKER_TIMER(MessageObject.SETTING, "birchParkRainmakerTimer"),
    SETTING_COMBAT_TIMER_DISPLAY(MessageObject.SETTING, "combatTimerDisplay"),
    SETTING_DISCORD_RP(MessageObject.SETTING, "discordRP"),
    SETTING_ENDSTONE_PROTECTOR_DISPLAY(MessageObject.SETTING, "endstoneProtectorDisplay"),
    SETTING_FANCY_WARP_MENU(MessageObject.SETTING, "fancyWarpMenu"),
    SETTING_DOUBLE_WARP(MessageObject.SETTING, "doubleWarp"),
    SETTING_ADVANCED_MODE(MessageObject.SETTING, "advancedMode"),
    SETTING_FREEZE_BACKPACK_PREVIEW(MessageObject.SETTING, "freezeBackpackPreview"),
    SETTING_HIDE_GREY_ENCHANTS(MessageObject.SETTING, "hideGreyEnchants"),
    SETTING_LEGENDARY_SEA_CREATURE_WARNING(MessageObject.SETTING, "legendarySeaCreatureWarning"),
    SETTING_ONLY_BREAK_LOGS_PARK(MessageObject.SETTING, "onlyBreakLogsPark"),
    SETTING_BOSS_APPROACH_ALERT(MessageObject.SETTING, "bossApproachAlert"),
    SETTING_DISABLE_TELEPORT_PAD_MESSAGES(MessageObject.SETTING, "disableTeleportPadMessages"),
    SETTING_BAIT_LIST(MessageObject.SETTING, "baitListDisplay"),
    SETTING_ZEALOT_COUNTER_EXPLOSIVE_BOW_SUPPORT(MessageObject.SETTING, "zealotCounterExplosiveBow"),
    SETTING_DISABLE_ENDERMAN_TELEPORTATION_EFFECT(MessageObject.SETTING, "disableEndermanTeleportation"),
    SETTING_CHANGE_ZEALOT_COLOR(MessageObject.SETTING, "changeZealotColor"),
    SETTING_HIDE_SVEN_PUP_NAMETAGS(MessageObject.SETTING, "hideSvenPupNametags"),
    SETTING_TURN_ALL_FEATURES_CHROMA(MessageObject.SETTING, "turnAllFeaturesChroma"),
    SETTING_DUNGEON_MAP_DISPLAY(MessageObject.SETTING, "dungeonMapDisplay"),
    SETTING_ROTATE_MAP(MessageObject.SETTING, "rotateMap"),
    SETTING_CENTER_ROTATION_ON_PLAYER(MessageObject.SETTING, "centerRotationOnYourPlayer"),
    SETTING_MAP_ZOOM(MessageObject.SETTING, "mapZoom"),
    SETTING_GLOWING_DROPPED_ITEMS(MessageObject.SETTING, "glowingDroppedItems"),
    SETTING_GLOWING_DUNGEON_TEAMMATES(MessageObject.SETTING, "outlineDungeonTeammates"),
    SETTING_SHOW_BASE_STAT_BOOST_PERCENTAGE(MessageObject.SETTING, "baseStatBoostPercentage"),
    SETTING_COLOR_BY_RARITY(MessageObject.SETTING, "colorByRarity"),
    SETTING_SHOW_PLAYER_HEAD_ON_MAP(MessageObject.SETTING, "showPlayerHeadsOnMap"),
    SETTING_SHOW_HEALING_CIRCLE_WALL(MessageObject.SETTING, "showHealingCircleWall"),
    SETTING_SHOW_CRITICAL_TEAMMATES(MessageObject.SETTING, "showCriticalTeammates"),
    SETTING_SHOW_GLOWING_ITEMS_ON_ISLAND(MessageObject.SETTING, "showGlowingItemsOnIsland"),
    SETTING_SHOW_ITEM_DUNGEON_FLOOR(MessageObject.SETTING, "showItemDungeonFloor"),
    SETTING_SHOW_DUNGEON_MILESTONE(MessageObject.SETTING, "showDungeonMilestone"),
    SETTING_DUNGEONS_COLLECTED_ESSENCES_DISPLAY(MessageObject.SETTING, "dungeonsCollectedEssencesDisplay"),
    SETTING_BONZO_STAFF_SOUNDS(MessageObject.SETTING, "stopBonzoStaffSounds"),
    SETTING_SHOW_RARITY_UPGRADED(MessageObject.SETTING, "showRarityUpgraded"),
    SETTING_REVENANT_SLAYER_TRACKER(MessageObject.SETTING, "revenantSlayerTracker"),
    SETTING_TARANTULA_SLAYER_TRACKER(MessageObject.SETTING, "tarantulaSlayerTracker"),
    SETTING_SVEN_SLAYER_TRACKER(MessageObject.SETTING, "svenSlayerTracker"),
    SETTING_TEXT_MODE(MessageObject.SETTING, "textMode"),
    SETTING_DRAGONS_NEST_ONLY(MessageObject.SETTING, "dragonsNestOnly"),
    SETTING_DRAGON_STATS_TRACKER(MessageObject.SETTING, "dragonStatsTracker"),
    SETTING_SKILL_ACTIONS_LEFT_UNTIL_NEXT_LEVEL(MessageObject.SETTING, "skillActionsLeftUntilNextLevel"),
    SETTING_HIDE_WHEN_NOT_IN_CRYPTS(MessageObject.SETTING, "hideWhenNotInCrypts"),
    SETTING_HIDE_WHEN_NOT_IN_SPIDERS_DEN(MessageObject.SETTING, "hideWhenNotInSpidersDen"),
    SETTING_HIDE_WHEN_NOT_IN_CASTLE(MessageObject.SETTING, "hideWhenNotInCastle"),
    SETTING_DUNGEON_DEATH_COUNTER(MessageObject.SETTING, "dungeonDeathCounter"),
    SETTING_SHOW_PERSONAL_COMPACTOR_PREVIEW(MessageObject.SETTING, "showPersonalCompactorPreview"),
    SETTING_SHOW_DUNGEON_TEAMMATE_NAME_OVERLAY(MessageObject.SETTING, "dungeonsTeammateNameOverlay"),
    SETTING_DISABLE_MORT_MESSAGES(MessageObject.SETTING, "disableMortMessages"),
    SETTING_DISABLE_BOSS_MESSAGES(MessageObject.SETTING, "disableBossMessages"),
    SETTING_HIDE_OTHER_PLAYERS_PRESENTS(MessageObject.SETTING, "hideOtherPlayersPresents"),
    SETTING_SHOW_EXPERIMENTATION_TABLE_TOOLTIPS(MessageObject.SETTING, "showExperimentationTableTooltips"),
    SETTING_SHOW_FETCHUR_TODAY(MessageObject.SETTING, "fetchurToday"),
    SETTING_SHOW_FETCHUR_IN_DWARVEN_ONLY(MessageObject.SETTING, "showFetchurOnlyInDwarven"),
    SETTING_SHOW_FETCHUR_ITEM_NAME(MessageObject.SETTING, "showFetchurItemName"),
    SETTING_SHOW_FETCHUR_INVENTORY_OPEN_ONLY(MessageObject.SETTING, "showFetchurInventoryOpenOnly"),
    SETTING_WARN_WHEN_FETCHUR_CHANGES(MessageObject.SETTING, "warnWhenFetchurChanges"),
    SETTING_STOP_RAT_SOUNDS(MessageObject.SETTING, "stopRatSounds"),
    SETTING_STOP_ONLY_RAT_SQUEAK(MessageObject.SETTING, "onlyStopRatSqueak"),
    BACKPACK_STYLE_REGULAR(MessageObject.BACKPACK_STYLE, "regular"),
    BACKPACK_STYLE_COMPACT(MessageObject.BACKPACK_STYLE, "compact"),
    SETTING_DISABLE_SPIRIT_SCEPTRE_MESSAGES(MessageObject.SETTING, "disableSpiritSceptreMessages"),
    SETTING_OUTBID_ALERT_SOUND(MessageObject.SETTING, "outbidAlertSound"),
    SETTING_BAL_BOSS_WARNING(MessageObject.SETTING, "balBossWarning"),
    SETTING_BROOD_MOTHER_WARNING(MessageObject.SETTING, "broodMotherWarning"),
    MESSAGE_DROP_CONFIRMATION(MessageObject.MESSAGES, "dropConfirmation"),
    MESSAGE_MAGMA_BOSS_WARNING(MessageObject.MESSAGES, "magmaBossWarning"),
    MESSAGE_BAL_BOSS_WARNING(MessageObject.MESSAGES, "balBossWarning"),
    MESSAGE_BROOD_MOTHER_WARNING(MessageObject.MESSAGES, "broodMotherWarning"),
    MESSAGE_FULL_INVENTORY(MessageObject.MESSAGES, "fullInventory"),
    MESSAGE_LABYMOD(MessageObject.MESSAGES, "labymod"),
    MESSAGE_MINION_CANNOT_REACH(MessageObject.MESSAGES, "minionCannotReach"),
    MESSAGE_MINION_IS_FULL(MessageObject.MESSAGES, "minionIsFull"),
    MESSAGE_CANCELLED_STEM_BREAK(MessageObject.MESSAGES, "cancelledStemBreak"),
    MESSAGE_SLOT_LOCKED(MessageObject.MESSAGES, "slotLocked"),
    MESSAGE_SUMMONING_EYE_FOUND(MessageObject.MESSAGES, "summoningEyeFound"),
    MESSAGE_CANCELLED_DROPPING(MessageObject.MESSAGES, "cancelledDropping"),
    MESSAGE_CLICK_MORE_TIMES(MessageObject.MESSAGES, "clickMoreTimes"),
    MESSAGE_CLICK_ONE_MORE_TIME(MessageObject.MESSAGES, "clickOneMoreTime"),
    MESSAGE_CANCELLED_CANE_BREAK(MessageObject.MESSAGES, "cancelledCaneBreak"),
    MESSAGE_FEATURE_DISABLED(MessageObject.MESSAGES, "featureDisabled"),
    MESSAGE_ANVIL_USES(MessageObject.MESSAGES, "anvilUses"),
    MESSAGE_CANCELLED_NON_ORES_BREAK(MessageObject.MESSAGES, "cancelledDeepCaverns"),
    MESSAGE_SPECIAL_ZEALOT_FOUND(MessageObject.MESSAGES, "specialZealotFound"),
    MESSAGE_BLOCK_INCOMPLETE_PATTERNS(MessageObject.MESSAGES, "blockIncompletePatterns"),
    MESSAGE_SEARCH_FEATURES(MessageObject.MESSAGES, "searchFeatures"),
    MESSAGE_DOWNLOADING_UPDATE(MessageObject.MESSAGES, "downloadingUpdateFile"),
    MESSAGE_ONLY_FEW_ARROWS_LEFT(MessageObject.MESSAGES, "onlyFewArrowsLeft"),
    MESSAGE_NO_ARROWS_LEFT(MessageObject.MESSAGES, "noArrowsLeft"),
    MESSAGE_CHOOSE_A_COLOR(MessageObject.MESSAGES, "chooseAColor"),
    MESSAGE_SELECTED_COLOR(MessageObject.MESSAGES, "selectedColor"),
    MESSAGE_SET_HEX_COLOR(MessageObject.MESSAGES, "setHexColor"),
    MESSAGE_RESCALE_FEATURES(MessageObject.MESSAGES, "rescaleFeatures"),
    MESSAGE_RESIZE_BARS(MessageObject.MESSAGES, "resizeBars"),
    MESSAGE_SHOW_COLOR_ICONS(MessageObject.MESSAGES, "showColorIcons"),
    MESSAGE_ENABLE_FEATURE_SNAPPING(MessageObject.MESSAGES, "enableFeatureSnapping"),
    MESSAGE_STAGE(MessageObject.MESSAGES, "stage"),
    MESSAGE_SWITCHED_SLOTS(MessageObject.MESSAGES, "switchedSlots"),
    MESSAGE_CLICK_TO_OPEN_LINK(MessageObject.MESSAGES, "clickToOpenLink"),
    MESSAGE_CLICK_TO_OPEN_FOLDER(MessageObject.MESSAGES, "clickToOpenFolder"),
    MESSAGE_FIRST_STATUS(MessageObject.MESSAGES, "firstStatus"),
    MESSAGE_SECOND_STATUS(MessageObject.MESSAGES, "secondStatus"),
    MESSAGE_FALLBACK_STATUS(MessageObject.MESSAGES, "fallbackStatus"),
    MESSAGE_LEGENDARY_SEA_CREATURE_WARNING(MessageObject.MESSAGES, "legendarySeaCreatureWarning"),
    MESSAGE_CANCELLED_NON_LOGS_BREAK(MessageObject.MESSAGES, "cancelledPark"),
    MESSAGE_BOSS_APPROACH_ALERT(MessageObject.MESSAGES, "bossApproaching"),
    MESSAGE_ENABLE_ALL(MessageObject.MESSAGES, "enableAll"),
    MESSAGE_DISABLE_ALL(MessageObject.MESSAGES, "disableAll"),
    MESSAGE_ONE_EFFECT_ACTIVE(MessageObject.MESSAGES, "effectActive"),
    MESSAGE_EFFECTS_ACTIVE(MessageObject.MESSAGES, "effectsActive"),
    MESSAGE_FETCHUR_TODAY(MessageObject.MESSAGES, "fetchurItem"),
    MESSAGE_FETCHUR_WARNING(MessageObject.MESSAGES, "fetchurWarning"),
    ANCHOR_POINT_TOP_LEFT(MessageObject.ANCHOR_POINT, "topLeft"),
    ANCHOR_POINT_TOP_RIGHT(MessageObject.ANCHOR_POINT, "topRight"),
    ANCHOR_POINT_BOTTOM_LEFT(MessageObject.ANCHOR_POINT, "bottomLeft"),
    ANCHOR_POINT_BOTTOM_RIGHT(MessageObject.ANCHOR_POINT, "bottomRight"),
    ANCHOR_POINT_HEALTH_BAR(MessageObject.ANCHOR_POINT, "healthBar"),
    TEXT_STYLE_ONE(MessageObject.TEXT_STYLE, "one"),
    TEXT_STYLE_TWO(MessageObject.TEXT_STYLE, "two"),
    TAB_FEATURES(MessageObject.TAB, "features"),
    TAB_FIXES(MessageObject.TAB, "fixes"),
    TAB_GUI_FEATURES(MessageObject.TAB, "guiFeatures"),
    TAB_GENERAL_SETTINGS(MessageObject.TAB, "generalSettings"),
    POWER_ORB_DISPLAY_STYLE_DETAILED(MessageObject.POWER_ORB_STYLE, "detailed"),
    POWER_ORB_DISPLAY_STYLE_COMPACT(MessageObject.POWER_ORB_STYLE, "compact"),
    CHROMA_MODE_ALL_THE_SAME(MessageObject.CHROMA_MODE, "allTheSame"),
    CHROME_MODE_FADE(MessageObject.CHROMA_MODE, "fade"),
    DISCORD_STATUS_NONE_TITLE(MessageObject.DISCORD_STATUS, "titleNone"),
    DISCORD_STATUS_NONE_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionNone"),
    DISCORD_STATUS_LOCATION_TITLE(MessageObject.DISCORD_STATUS, "titleLocation"),
    DISCORD_STATUS_LOCATION_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionLocation"),
    DISCORD_STATUS_PURSE_TITLE(MessageObject.DISCORD_STATUS, "titlePurse"),
    DISCORD_STATUS_PURSE_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionPurse"),
    DISCORD_STATUS_BITS_TITLE(MessageObject.DISCORD_STATUS, "titleBits"),
    DISCORD_STATUS_BITS_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionBits"),
    DISCORD_STATUS_STATS_TITLE(MessageObject.DISCORD_STATUS, "titleStats"),
    DISCORD_STATUS_STATS_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionStats"),
    DISCORD_STATUS_ZEALOTS_TITLE(MessageObject.DISCORD_STATUS, "titleZealots"),
    DISCORD_STATUS_ZEALOTS_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionZealots"),
    DISCORD_STATUS_ITEM_TITLE(MessageObject.DISCORD_STATUS, "titleItem"),
    DISCORD_STATUS_ITEM_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionItem"),
    DISCORD_STATUS_TIME_TITLE(MessageObject.DISCORD_STATUS, "titleTime"),
    DISCORD_STATUS_TIME_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionTime"),
    DISCORD_STATUS_PROFILE_TITLE(MessageObject.DISCORD_STATUS, "titleProfile"),
    DISCORD_STATUS_PROFILE_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionProfile"),
    DISCORD_STATUS_CUSTOM(MessageObject.DISCORD_STATUS, "titleCustom"),
    DISCORD_STATUS_CUSTOM_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionCustom"),
    DISCORD_STATUS_AUTO(MessageObject.DISCORD_STATUS, "titleAuto"),
    DISCORD_STATUS_AUTO_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionAuto"),
    DISCORD_STATUS_REVENANT(MessageObject.DISCORD_STATUS, "titleRevenants"),
    DISCORD_STATUS_REVENANT_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionRevenants"),
    DISCORD_STATUS_SVEN(MessageObject.DISCORD_STATUS, "titleSvens"),
    DISCORD_STATUS_SVEN_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionSvens"),
    DISCORD_STATUS_TARANTULA(MessageObject.DISCORD_STATUS, "titleTarantula"),
    DISCORD_STATUS_TARANTULA_DESCRIPTION(MessageObject.DISCORD_STATUS, "descriptionTarantula"),
    COMMAND_USAGE_SBA(MessageObject.COMMAND_USAGE, "sba"),
    COMMAND_USAGE_SBA_BRAND(MessageObject.COMMAND_USAGE, "sba.brand"),
    COMMAND_USAGE_SBA_BRAND_BRAND_OUTPUT(MessageObject.COMMAND_USAGE, "sba.brand.brandOutput"),
    COMMAND_USAGE_SBA_BRAND_NOT_FOUND(MessageObject.COMMAND_USAGE, "sba.brand.notFound"),
    COMMAND_USAGE_SBA_COPY_ENTITY(MessageObject.COMMAND_USAGE, "sba.copyEntity"),
    COMMAND_USAGE_SBA_SLAYER(MessageObject.COMMAND_USAGE, "sba.slayer"),
    COMMAND_USAGE_SBA_COPY_SIDEBAR(MessageObject.COMMAND_USAGE, "sba.copySidebar"),
    COMMAND_USAGE_SBA_COPY_TAB_LIST(MessageObject.COMMAND_USAGE, "sba.copyTabList"),
    COMMAND_USAGE_SBA_DEV(MessageObject.COMMAND_USAGE, "sba.dev"),
    COMMAND_USAGE_SBA_DEV_DISABLED(MessageObject.COMMAND_USAGE, "sba.dev.disabled"),
    COMMAND_USAGE_SBA_DEV_ENABLED(MessageObject.COMMAND_USAGE, "sba.dev.enabled"),
    COMMAND_USAGE_SBA_EDIT(MessageObject.COMMAND_USAGE, "sba.edit"),
    COMMAND_USAGE_SBA_FOLDER(MessageObject.COMMAND_USAGE, "sba.folder"),
    COMMAND_USAGE_SBA_FOLDER_ERROR(MessageObject.COMMAND_USAGE, "sba.folder.error"),
    COMMAND_USAGE_SBA_HELP(MessageObject.COMMAND_USAGE, "sba.help"),
    COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER(MessageObject.COMMAND_USAGE, "sba.set.zealotCounter"),
    COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_EYES(MessageObject.COMMAND_USAGE, "sba.set.zealotCounter.eyes"),
    COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_TOTAL_ZEALOTS(MessageObject.COMMAND_USAGE, "sba.set.zealotCounter.totalZealots"),
    COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_WRONG_USAGE(MessageObject.COMMAND_USAGE, "sba.set.zealotCounter.wrongUsage"),
    COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_ZEALOTS(MessageObject.COMMAND_USAGE, "sba.set.zealotCounter.zealots"),
    COMMAND_USAGE_TOGGLE_ACTION_BAR_LOGGING(MessageObject.COMMAND_USAGE, "sba.toggleActionBarLogging"),
    COMMAND_USAGE_TOGGLE_ACTION_BAR_LOGGING_DISABLED(MessageObject.COMMAND_USAGE, "sba.toggleActionBarLogging.disabled"),
    COMMAND_USAGE_TOGGLE_ACTION_BAR_LOGGING_ENABLED(MessageObject.COMMAND_USAGE, "sba.toggleActionBarLogging.enabled"),
    COMMAND_USAGE_WRONG_USAGE_GENERIC(MessageObject.COMMAND_USAGE, "sba.wrongUsage.generic"),
    COMMAND_USAGE_WRONG_USAGE_SUBCOMMAND_NOT_FOUND(MessageObject.COMMAND_USAGE, "sba.wrongUsage.subCommandNotFound"),
    SUBCOMMAND_HELP_COPY_ENTITY(MessageObject.COMMAND_USAGE, "sba.help.copyEntity"),
    SUBCOMMAND_HELP_COPY_ENTITY_ENTITY_NAMES(MessageObject.COMMAND_USAGE, "sba.help.copyEntity.entityNames"),
    SUBCOMMAND_HELP_COPY_ENTITY_RADIUS(MessageObject.COMMAND_USAGE, "sba.help.copyEntity.radius"),
    SUBCOMMAND_HELP_COPY_SIDEBAR_FORMATTED(MessageObject.COMMAND_USAGE, "sba.help.copySidebar.formatted"),
    SUBCOMMAND_HELP_COPY_TAB_LIST(MessageObject.COMMAND_USAGE, "sba.help.copyTabList"),
    SUBCOMMAND_HELP_DEV(MessageObject.COMMAND_USAGE, "sba.help.dev"),
    SUBCOMMAND_HELP_HELP_COMMAND(MessageObject.COMMAND_USAGE, "sba.help.help.command"),
    SUBCOMMAND_HELP_SET_ZEALOT_COUNTER(MessageObject.COMMAND_USAGE, "sba.help.set.zealotCounter"),
    SUBCOMMAND_HELP_SET_ZEALOT_COUNTER_EYES(MessageObject.COMMAND_USAGE, "sba.help.set.zealotCounter.eyes"),
    SUBCOMMAND_HELP_SET_ZEALOT_COUNTER_TOTAL_ZEALOTS(MessageObject.COMMAND_USAGE, "sba.help.set.zealotCounter.totalZealots"),
    SUBCOMMAND_HELP_SET_ZEALOT_COUNTER_ZEALOTS(MessageObject.COMMAND_USAGE, "sba.help.set.zealotCounter.zealots"),
    SUBCOMMAND_HELP_SLAYER(MessageObject.COMMAND_USAGE, "sba.help.slayer"),
    SUBCOMMAND_HELP_SUBCOMMAND_NOT_FOUND(MessageObject.COMMAND_USAGE, "sba.help.subCommandNotFound"),
    KEY_DEVELOPER_COPY_NBT(MessageObject.KEYBINDINGS, "developerCopyNBT");

    private final MessageObject messageObject;
    private final String memberName;

    private Message(MessageObject messageObject, String memberName) {
        this.messageObject = messageObject;
        this.memberName = memberName;
    }

    public String getMessage(String ... variables) {
        String text;
        try {
            SkyblockAddons main = SkyblockAddons.getInstance();
            List<String> path = this.getMessageObject().getPath();
            JsonObject jsonObject = main.getConfigValues().getLanguageConfig();
            for (String part : path) {
                if (part.equals("")) continue;
                jsonObject = jsonObject.getAsJsonObject(part);
            }
            text = jsonObject.get(this.getMemberName()).getAsString();
            if (text != null) {
                if (this == SETTING_BACKPACK_STYLE) {
                    text = text.replace("%style%", main.getConfigValues().getBackpackStyle().getMessage());
                } else if (this == SETTING_POWER_ORB_DISPLAY_STYLE) {
                    text = text.replace("%style%", main.getConfigValues().getPowerOrbDisplayStyle().getMessage());
                } else if (this == SETTING_GUI_SCALE) {
                    text = text.replace("%scale%", variables[0]);
                } else if (this == SETTING_TEXT_STYLE) {
                    text = text.replace("%style%", main.getConfigValues().getTextStyle().getMessage());
                } else if (this == MESSAGE_MINION_CANNOT_REACH) {
                    text = text.replace("%type%", variables[0]);
                } else if (this == MESSAGE_CLICK_MORE_TIMES) {
                    text = text.replace("%times%", variables[0]);
                } else if (this == MESSAGE_ANVIL_USES) {
                    text = text.replace("%uses%", (Object)((Object)main.getConfigValues().getRestrictedColor(Feature.SHOW_ITEM_ANVIL_USES)) + variables[0] + (Object)((Object)ColorCode.GRAY));
                } else if (this == MESSAGE_ONLY_FEW_ARROWS_LEFT) {
                    text = text.replace("%arrows%", variables[0]);
                } else if (this == MESSAGE_STAGE) {
                    text = text.replace("%stage%", variables[0]);
                } else if (this == COMMAND_USAGE_SBA_BRAND_BRAND_OUTPUT) {
                    text = text.replace("%brand%", variables[0]);
                } else if (this == COMMAND_USAGE_SBA_DEV_ENABLED) {
                    text = text.replace("%keyName%", variables[0]);
                } else if (this == COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_EYES || this == COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_TOTAL_ZEALOTS || this == COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_ZEALOTS) {
                    text = text.replace("%number%", variables[0]);
                } else if (this == COMMAND_USAGE_SBA_SET_ZEALOT_COUNTER_WRONG_USAGE) {
                    text = text.replace("%options%", variables[0]);
                } else if (this == COMMAND_USAGE_WRONG_USAGE_SUBCOMMAND_NOT_FOUND) {
                    text = text.replace("%sub-command%", variables[0]);
                } else if (this == SUBCOMMAND_HELP_COPY_ENTITY) {
                    text = text.replace("%radius%", variables[0]);
                } else if (this == MESSAGE_EFFECTS_ACTIVE) {
                    text = text.replace("%number%", variables[0]);
                } else if (this == MESSAGE_FETCHUR_TODAY) {
                    text = text.replace("%item%", variables[0]);
                }
            }
            if (!(text == null || main.getConfigValues().getLanguage() != Language.HEBREW && main.getConfigValues().getLanguage() != Language.ARABIC || Minecraft.func_71410_x().field_71466_p.func_78260_a())) {
                text = this.bidiReorder(text);
            }
        }
        catch (NullPointerException ex) {
            text = this.memberName;
        }
        return text;
    }

    private String bidiReorder(String text) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException var3) {
            return text;
        }
    }

    public MessageObject getMessageObject() {
        return this.messageObject;
    }

    public String getMemberName() {
        return this.memberName;
    }

    static enum MessageObject {
        ROOT(""),
        SETTING("settings"),
        MESSAGES("messages"),
        BACKPACK_STYLE("settings.backpackStyles"),
        POWER_ORB_STYLE("settings.powerOrbStyle"),
        TEXT_STYLE("settings.textStyles"),
        TAB("settings.tab"),
        ANCHOR_POINT("settings.anchorPoints"),
        CHROMA_MODE("settings.chromaModes"),
        DISCORD_STATUS("discordStatus"),
        KEYBINDINGS("keyBindings"),
        COMMAND_USAGE("commandUsage");

        private final List<String> path;

        private MessageObject(String path) {
            this.path = new LinkedList<String>(Arrays.asList(path.split(Pattern.quote("."))));
        }

        public List<String> getPath() {
            return this.path;
        }
    }
}

