/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.utils.data;

import codes.biscuit.skyblockaddons.exceptions.LoadingException;
import codes.biscuit.skyblockaddons.utils.data.DataFetchCallback;
import codes.biscuit.skyblockaddons.utils.data.DataUtils;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;

public class RemoteFileRequest<T> {
    protected static final String NO_DATA_RECEIVED_ERROR = "No data received for get request to \"%s\"";
    private final String REQUEST_URL;
    private final ResponseHandler<T> RESPONSE_HANDLER;
    private final FutureCallback<T> FETCH_CALLBACK;
    private final boolean ESSENTIAL;
    private HttpRequestFutureTask<T> futureTask;

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked @NonNull but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked @NonNull but is null");
        }
        this.REQUEST_URL = "https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/" + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = new DataFetchCallback(URI.create(this.REQUEST_URL));
        this.ESSENTIAL = false;
        this.futureTask = null;
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, @NonNull FutureCallback<T> fetchCallback) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked @NonNull but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked @NonNull but is null");
        }
        if (fetchCallback == null) {
            throw new NullPointerException("fetchCallback is marked @NonNull but is null");
        }
        this.REQUEST_URL = "https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/" + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = fetchCallback;
        this.ESSENTIAL = false;
        this.futureTask = null;
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, boolean essential) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked @NonNull but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked @NonNull but is null");
        }
        this.REQUEST_URL = "https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/" + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = new DataFetchCallback(URI.create(this.REQUEST_URL));
        this.ESSENTIAL = essential;
        this.futureTask = null;
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, boolean essential, boolean usingCustomUrl) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked @NonNull but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked @NonNull but is null");
        }
        this.REQUEST_URL = usingCustomUrl ? requestPath : "https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/" + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = new DataFetchCallback(URI.create(this.REQUEST_URL));
        this.ESSENTIAL = essential;
        this.futureTask = null;
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, @NonNull FutureCallback<T> fetchCallback, boolean essential) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked @NonNull but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked @NonNull but is null");
        }
        if (fetchCallback == null) {
            throw new NullPointerException("fetchCallback is marked @NonNull but is null");
        }
        this.REQUEST_URL = "https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/" + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = fetchCallback;
        this.ESSENTIAL = essential;
        this.futureTask = null;
    }

    public void execute(@NonNull FutureRequestExecutionService executionService) {
        if (executionService == null) {
            throw new NullPointerException("executionService is marked @NonNull but is null");
        }
        String requestURL = DataUtils.useFallbackCDN ? this.REQUEST_URL.replace("https://cdn.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/", "https://fastly.jsdelivr.net/gh/BiscuitDevelopment/SkyblockAddons-Data/") : this.REQUEST_URL;
        this.futureTask = executionService.execute((HttpUriRequest)new HttpGet(requestURL), null, this.RESPONSE_HANDLER, this.FETCH_CALLBACK);
    }

    public void load() throws InterruptedException, ExecutionException, RuntimeException {
        throw new LoadingException(String.format("Loading method not implemented for file %s", this.REQUEST_URL.substring(this.REQUEST_URL.lastIndexOf(48))), new RuntimeException());
    }

    public String getUrl() {
        return this.REQUEST_URL;
    }

    public boolean isEssential() {
        return this.ESSENTIAL;
    }

    protected T getResult() throws InterruptedException, ExecutionException, RuntimeException {
        return (T)this.futureTask.get();
    }

    protected boolean isDone() {
        return this.futureTask.isDone();
    }

    public HttpRequestFutureTask<T> getFutureTask() {
        return this.futureTask;
    }
}

